<?php
/**
 * Class that operate on table 'offerorder'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2019-09-24 12:55
 */
class OfferorderMySqlDAO implements OfferorderDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return OfferorderMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM offerorder WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM offerorder';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM offerorder ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param offerorder primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM offerorder WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param OfferorderMySql offerorder
 	 */
	public function insert($offerorder){
		$sql = 'INSERT INTO offerorder (datenow, userid, del, client, mydate, alltotal, allquantity, allquantstore, pricestore, allquantavailable, priceavailable, allquantmiun, pricemiun, oldorder, oldoffer) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($offerorder->datenow);
		$sqlQuery->setNumber($offerorder->userid);
		$sqlQuery->setNumber($offerorder->del);
		$sqlQuery->setNumber($offerorder->client);
		$sqlQuery->set($offerorder->mydate);
		$sqlQuery->setNumber($offerorder->alltotal);
		$sqlQuery->setNumber($offerorder->allquantity);
		$sqlQuery->setNumber($offerorder->allquantstore);
		$sqlQuery->setNumber($offerorder->pricestore);
		$sqlQuery->setNumber($offerorder->allquantavailable);
		$sqlQuery->setNumber($offerorder->priceavailable);
		$sqlQuery->setNumber($offerorder->allquantmiun);
		$sqlQuery->setNumber($offerorder->pricemiun);
		$sqlQuery->setNumber($offerorder->oldorder);
		$sqlQuery->setNumber($offerorder->oldoffer);

		$id = $this->executeInsert($sqlQuery);	
		$offerorder->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param OfferorderMySql offerorder
 	 */
	public function update($offerorder){
		$sql = 'UPDATE offerorder SET datenow = ?, userid = ?, del = ?, client = ?, mydate = ?, alltotal = ?, allquantity = ?, allquantstore = ?, pricestore = ?, allquantavailable = ?, priceavailable = ?, allquantmiun = ?, pricemiun = ?, oldorder = ?, oldoffer = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($offerorder->datenow);
		$sqlQuery->setNumber($offerorder->userid);
		$sqlQuery->setNumber($offerorder->del);
		$sqlQuery->setNumber($offerorder->client);
		$sqlQuery->set($offerorder->mydate);
		$sqlQuery->setNumber($offerorder->alltotal);
		$sqlQuery->setNumber($offerorder->allquantity);
		$sqlQuery->setNumber($offerorder->allquantstore);
		$sqlQuery->setNumber($offerorder->pricestore);
		$sqlQuery->setNumber($offerorder->allquantavailable);
		$sqlQuery->setNumber($offerorder->priceavailable);
		$sqlQuery->setNumber($offerorder->allquantmiun);
		$sqlQuery->setNumber($offerorder->pricemiun);
		$sqlQuery->setNumber($offerorder->oldorder);
		$sqlQuery->setNumber($offerorder->oldoffer);

		$sqlQuery->setNumber($offerorder->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM offerorder';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByDatenow($value){
		$sql = 'SELECT * FROM offerorder WHERE datenow = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserid($value){
		$sql = 'SELECT * FROM offerorder WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDel($value){
		$sql = 'SELECT * FROM offerorder WHERE del = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByClient($value){
		$sql = 'SELECT * FROM offerorder WHERE client = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByMydate($value){
		$sql = 'SELECT * FROM offerorder WHERE mydate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAlltotal($value){
		$sql = 'SELECT * FROM offerorder WHERE alltotal = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAllquantity($value){
		$sql = 'SELECT * FROM offerorder WHERE allquantity = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAllquantstore($value){
		$sql = 'SELECT * FROM offerorder WHERE allquantstore = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPricestore($value){
		$sql = 'SELECT * FROM offerorder WHERE pricestore = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAllquantavailable($value){
		$sql = 'SELECT * FROM offerorder WHERE allquantavailable = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPriceavailable($value){
		$sql = 'SELECT * FROM offerorder WHERE priceavailable = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAllquantmiun($value){
		$sql = 'SELECT * FROM offerorder WHERE allquantmiun = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPricemiun($value){
		$sql = 'SELECT * FROM offerorder WHERE pricemiun = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByOldorder($value){
		$sql = 'SELECT * FROM offerorder WHERE oldorder = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByOldoffer($value){
		$sql = 'SELECT * FROM offerorder WHERE oldoffer = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByDatenow($value){
		$sql = 'DELETE FROM offerorder WHERE datenow = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserid($value){
		$sql = 'DELETE FROM offerorder WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDel($value){
		$sql = 'DELETE FROM offerorder WHERE del = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByClient($value){
		$sql = 'DELETE FROM offerorder WHERE client = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByMydate($value){
		$sql = 'DELETE FROM offerorder WHERE mydate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAlltotal($value){
		$sql = 'DELETE FROM offerorder WHERE alltotal = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAllquantity($value){
		$sql = 'DELETE FROM offerorder WHERE allquantity = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAllquantstore($value){
		$sql = 'DELETE FROM offerorder WHERE allquantstore = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPricestore($value){
		$sql = 'DELETE FROM offerorder WHERE pricestore = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAllquantavailable($value){
		$sql = 'DELETE FROM offerorder WHERE allquantavailable = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPriceavailable($value){
		$sql = 'DELETE FROM offerorder WHERE priceavailable = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAllquantmiun($value){
		$sql = 'DELETE FROM offerorder WHERE allquantmiun = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPricemiun($value){
		$sql = 'DELETE FROM offerorder WHERE pricemiun = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByOldorder($value){
		$sql = 'DELETE FROM offerorder WHERE oldorder = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByOldoffer($value){
		$sql = 'DELETE FROM offerorder WHERE oldoffer = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return OfferorderMySql 
	 */
	protected function readRow($row){
		$offerorder = new Offerorder();
		
		$offerorder->id = $row['id'];
		$offerorder->datenow = $row['datenow'];
		$offerorder->userid = $row['userid'];
		$offerorder->del = $row['del'];
		$offerorder->client = $row['client'];
		$offerorder->mydate = $row['mydate'];
		$offerorder->alltotal = $row['alltotal'];
		$offerorder->allquantity = $row['allquantity'];
		$offerorder->allquantstore = $row['allquantstore'];
		$offerorder->pricestore = $row['pricestore'];
		$offerorder->allquantavailable = $row['allquantavailable'];
		$offerorder->priceavailable = $row['priceavailable'];
		$offerorder->allquantmiun = $row['allquantmiun'];
		$offerorder->pricemiun = $row['pricemiun'];
		$offerorder->oldorder = $row['oldorder'];
		$offerorder->oldoffer = $row['oldoffer'];

		return $offerorder;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return OfferorderMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>